/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em.capability;

import com.fuzs.puzzleslib_em.capability.core.CapabilityDispatcher;
import com.fuzs.puzzleslib_em.capability.core.CapabilityStorage;
import com.google.common.collect.ArrayListMultimap;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class CapabilityController {
    private final ArrayListMultimap<Class<?>, Pair<ResourceLocation, Function<Object, CapabilityDispatcher<?>>>> capabilityEntries = ArrayListMultimap.create();

    public CapabilityController() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<?> evt) {
        this.capabilityEntries.get((Object)((Class)evt.getGenericType())).forEach(capability -> {
            Optional optional = Optional.ofNullable(((Function)capability.getRight()).apply(evt.getObject()));
            optional.ifPresent(dispatcher -> evt.addCapability((ResourceLocation)capability.getLeft(), (ICapabilityProvider)dispatcher));
        });
    }

    private <T extends INBTSerializable<CompoundNBT>, S extends CapabilityProvider<S>> void addCapability(Class<S> genericType, ResourceLocation path, Class<T> capabilityType, Callable<T> capabilityFactory, Function<Object, CapabilityDispatcher<?>> function) {
        CapabilityController.register(capabilityType, capabilityFactory);
        this.capabilityEntries.put(genericType, (Object)Pair.of((Object)path, function));
    }

    public <T extends INBTSerializable<CompoundNBT>> void addItemStackCapability(ResourceLocation path, Class<T> capabilityType, Callable<T> capabilityFactory, Function<Object, CapabilityDispatcher<?>> function) {
        this.addCapability(ItemStack.class, path, capabilityType, capabilityFactory, function);
    }

    public <T extends INBTSerializable<CompoundNBT>> void addEntityCapability(ResourceLocation path, Class<T> capabilityType, Callable<T> capabilityFactory, Function<Object, CapabilityDispatcher<?>> function) {
        this.addCapability(Entity.class, path, capabilityType, capabilityFactory, function);
    }

    public <T extends INBTSerializable<CompoundNBT>> void addTileEntityCapability(ResourceLocation path, Class<T> capabilityType, Callable<T> capabilityFactory, Function<Object, CapabilityDispatcher<?>> function) {
        this.addCapability(TileEntity.class, path, capabilityType, capabilityFactory, function);
    }

    public <T extends INBTSerializable<CompoundNBT>> void addWorldCapability(ResourceLocation path, Class<T> capabilityType, Callable<T> capabilityFactory, Function<Object, CapabilityDispatcher<?>> function) {
        this.addCapability(World.class, path, capabilityType, capabilityFactory, function);
    }

    public <T extends INBTSerializable<CompoundNBT>> void addChunkCapability(ResourceLocation path, Class<T> capabilityType, Callable<T> capabilityFactory, Function<Object, CapabilityDispatcher<?>> function) {
        this.addCapability(Chunk.class, path, capabilityType, capabilityFactory, function);
    }

    private static <T> void register(Class<T> type, Callable<? extends T> factory) {
        CapabilityManager.INSTANCE.register(type, new CapabilityStorage(), factory);
    }

    @Nonnull
    public static <T> LazyOptional<T> getCapability(ICapabilityProvider provider, Capability<T> cap) {
        return provider.getCapability(cap);
    }
}

